/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.api.crop;

import com.agricraft.agricraft.api.codecs.AgriSoil;
import com.agricraft.agricraft.api.config.CoreConfig;
import com.agricraft.agricraft.api.crop.AgriGrowthStage;
import com.agricraft.agricraft.api.fertilizer.IAgriFertilizable;
import com.agricraft.agricraft.api.genetic.AgriGenomeProvider;
import com.agricraft.agricraft.api.plant.AgriPlant;
import com.agricraft.agricraft.api.plant.AgriWeed;
import com.agricraft.agricraft.api.requirement.AgriGrowthResponse;
import com.agricraft.agricraft.api.stat.AgriStatRegistry;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public interface AgriCrop
extends AgriGenomeProvider,
IAgriFertilizable {
    public boolean hasPlant();

    public boolean hasWeeds();

    public boolean hasCropSticks();

    public boolean isCrossCropSticks();

    public String getPlantId();

    public AgriPlant getPlant();

    public AgriGrowthStage getGrowthStage();

    public void setGrowthStage(AgriGrowthStage var1);

    public String getWeedId();

    public AgriWeed getWeed();

    public AgriGrowthStage getWeedGrowthStage();

    public void setWeedGrowthStage(AgriGrowthStage var1);

    public void removeWeeds();

    default public double getGrowthPercent() {
        return this.getGrowthStage().growthPercentage();
    }

    default public boolean isFullyGrown() {
        return this.getGrowthStage().isFinal();
    }

    default public boolean canBeHarvested() {
        return this.hasPlant() && this.getGrowthStage().isMature();
    }

    default public boolean isFertile() {
        return this.getFertilityResponse().isFertile();
    }

    public AgriGrowthResponse getFertilityResponse();

    public Optional<AgriSoil> getSoil();

    default public boolean harvest(Consumer<class_1799> consumer, @Nullable class_1309 entity) {
        if (this.canBeHarvested()) {
            this.getHarvestProducts(consumer);
            this.setGrowthStage(this.getPlant().getGrowthStageAfterHarvest());
            this.getPlant().onHarvest(this, entity);
            return true;
        }
        return false;
    }

    public void getHarvestProducts(Consumer<class_1799> var1);

    public void getClippingProducts(Consumer<class_1799> var1, class_1799 var2);

    default public boolean shouldWeedsActivate() {
        if (CoreConfig.disableWeeds || this.method_10997() == null) {
            return false;
        }
        if (this.hasPlant()) {
            int resistance = this.getGenome().getResistance();
            int max = AgriStatRegistry.getInstance().resistanceStat().getMax();
            return this.method_10997().method_8409().method_43048(max) >= (max + resistance) / 2;
        }
        return this.method_10997().method_8409().method_43056();
    }

    public void setWeed(String var1, AgriWeed var2);

    public class_2338 method_11016();

    public class_2680 method_11010();

    public class_1937 method_10997();

    default public class_2586 asBlockEntity() {
        return (class_2586)this;
    }
}

